/*

    This file is for scripts that are specific to the Mid-Century Theme

*/

function galleryNext() {
    var nextItemNumber = currentItem + 1;
    if (nextItemNumber <= lastItem ) {
        var currentItemId = 'gallery-item-' + currentItem;
        var nextItemId = 'gallery-item-' + nextItemNumber;
        var currentItemObj = document.getElementById(currentItemId);
        var nextItemObj = document.getElementById(nextItemId);
        $(currentItemObj).fadeOut(400, function() {
            $(nextItemObj).fadeIn(400);
        });
        currentItem = nextItemNumber;
        document.getElementById('showcase-prev').className = 'active';
        if (currentItem == lastItem) {
            document.getElementById('showcase-next').className = 'inactive';
        } else {
            document.getElementById('showcase-next').className = 'active';
        }
    }
}
function galleryPrev() {
    var prevItemNumber = currentItem - 1;
    if (prevItemNumber > 0) {
        var currentItemId = 'gallery-item-' + currentItem;
        var prevItemId = 'gallery-item-' + prevItemNumber;
        var currentItemObj = document.getElementById(currentItemId);
        var prevItemObj = document.getElementById(prevItemId);
        $(currentItemObj).fadeOut(400, function() {
            $(prevItemObj).fadeIn(400);
        });
        currentItem = prevItemNumber;
        document.getElementById('showcase-next').className = 'active';
        if (currentItem == 1) {
            document.getElementById('showcase-prev').className = 'inactive';
        } else {
            document.getElementById('showcase-prev').className = 'active';
        }
    }
}

function dialogShow(imageUrl,imageHeight,imageWidth,imageId) {
    var dialogImage = document.createElement('img');
    $("#dialog-content").append(dialogImage);
    $(dialogImage).attr("src",imageUrl);
    
    var dialogWidth = imageWidth + 40;
    if ((imageHeight > imageWidth) && (imageHeight > 450)) { // portrait
        $(dialogImage).attr("height","400");
        var imageRatio = 400 / imageHeight;
        var dialogWidth = parseInt(imageWidth * imageRatio) + 40;
    } else { // landscape
        if (imageWidth > 500) {
            $(dialogImage).attr("width","500");
            dialogWidth = 540;
        }
    }
    // create title and description
    var dialogText = document.createElement('div');
    $(dialogText).attr("id","dialog-text");
    var dialogTextInner = document.createElement('div');
    $(dialogTextInner).attr("id","dialog-text-inner");
    $(dialogTextInner).attr("onmouseover","dialogTextShow('dialog-text')");
    $(dialogTextInner).attr("onmouseout","dialogTextHide('dialog-text')");
    var dialogTitle = document.createElement('h2');
    var dialogDescription = document.createElement('div');
    
    // get content from gallery
    var wrapper = document.getElementById(imageId);
    var imageTitle = $(wrapper).find("h3").text();
    var imageDescription = $(wrapper).find("div").html();
    
    $(dialogTitle).text(imageTitle);
    $(dialogDescription).html(imageDescription);
    
    $("#dialog-content").append(dialogText);
    $(dialogText).append(dialogTextInner);
    $(dialogTextInner).append(dialogTitle);
    $(dialogTextInner).append(dialogDescription);
    
    $(dialogImage).hover(
        function () {
            $(dialogText).show();
        },
        function () {
            $(dialogText).hide();
        }
    );

    $("#dialog-inner").css("width",dialogWidth);
    
    $("#overlay").show();
    $("#dialog").show();
}
function dialogClose() {
    $("#overlay").hide();
    $("#dialog").hide();
    $("#dialog-content").empty();
}




